#include <iostream>

// Curiously Recurring Template Pattern

class Vehicle
{
public:
  virtual Vehicle* clone()const = 0;
};

template<typename Derived>
class VehicleInterface : public Vehicle
{
  virtual Vehicle* clone()const
  {
    return new Derived(*static_cast<const Derived*>(this));
  }
  
};

class Car : public VehicleInterface<Car>
{
};

int main(void)
{
  Vehicle* transport = new Car;
  Vehicle* newWheels = transport->clone();
}
