#include <functional>
#include <iostream>

double operate(double x, double y)
{
  return x + 2*y;
}

struct Object
{
  double func(double x, double y)const
  {
    return x + y * data;
  }
  
  double updateData(double x)
  {
    data = x;
    return x*x;
  }
  
  double data;
};

void func(const Object& p, const std::function<double(double)>& f)
{
  std::cout << p.data << std::endl;
  f(20);
  std::cout << p.data << std::endl; // p.data will have changed due to f.
}


int main(void)
{
  std::function<double(double, double)> op = operate;
  std::cout << "operate(3.2, 4.3) = " << op(3.2, 4.3) << std::endl;

  std::function<double(double)> op2 = std::bind(operate, std::placeholders::_1, 4.5);
  std::cout << "operate(1, 4.5) = " << op2(1) << std::endl;

  std::function<double(double)> op3 = std::bind(operate, std::placeholders::_1, std::placeholders::_1);
  std::cout << "operate(1, 1) = " << op3(1) << std::endl;

  Object o;
  o.data = 10;

  std::function<double(double)> op4 = std::bind(std::mem_fn(&Object::func),
						&o, std::placeholders::_1, 3.0);
  std::cout << "o.func(4, 3) = " << op4(4) << std::endl;

  func(o, std::bind(std::mem_fn(&Object::updateData), &o, std::placeholders::_1));

  return 0;
}
