#include <iostream>
#include <algorithm>

int main(void)
{
  std::vector<int> a{ -1, 5, 10, -9, 12, 3  };

  int cutoff = 5;

  std::for_each(a.begin(), a.end(), [cutoff](int x){if(x < cutoff) std::cout << x << ",";} );

  std::cout << std::endl;

  std::vector<int> b(a.size());
  std::transform(a.begin(), a.end(), b.begin(), [cutoff](int x){return (x < cutoff) ? x : 0;} );

  for(int i : b)
  {
    std::cout << i << ", ";
  }
  std::cout << std::endl;

  std::sort(a.begin(), a.end(), [](int a, int b){return (a % 10 < b % 10);});

  for(int i : a)
  {
    std::cout << i << ", ";
  }
  std::cout << std::endl;

  return 0;
}
