#include <type_traits>
#include <iostream>

template<typename T>
void print(const T& s)
{
  if(std::is_arithmetic<T>::value)
  {
    std::cout << "Number: " << s << std::endl;
  }
  else if(std::is_pointer<T>::value)
  {
    std::cout << "Pointer " << std::hex << s << std::endl;
  }
}

int main(void)
{
  print(10.0);
  int * p = new int;
  print(p);
  print(5);
  delete p;
}
