#include <iostream>

struct Func
{
  // Function returning an integer
  int F()const
  {
    return 2;
  }  
};

// Struct that can be default constructed
// and initializes its internal data.
// Can also be cast to an integer, using its internal data.
struct Obj
{
  struct F
  {
    F()
    {
      data = 3;
    }
    
    // Cast to integer
    operator int()
    {
      return data;
    }
    
    int data;
  };
};

// This is the interesting bit...
template<typename X>
struct Y : X
{
  // The line 'using /*typename*/ X::F;' is needed to bring F into scope
  // If F is going to be a function, then line is valid without 'typename'
  // otherwise need "using typename X::F;" instead (since X::F is then a type).

  // N3242:14.6.2 suggests that the "using X::F" syntax should not be necessary
  // if F is a function (i.e. not a type), even though it depends. However no compiler I tested 
  // would accept that F() could refer to a function without this. Perhaps I'm misreading the standard.

  /* Interestingly, the Intel compiler (12.1.3) doesn't require the 'typename'
     even if F is a struct, and compiles Y<Obj> correctly.
     I believe this is wrong according to the standard.

     clang (3.1) does require typename for Y<Obj> (correctly according to the standard)
     as does gcc-4.7

     However, even with typename, gcc-4.6.3 fails to compile Y<Obj>.
   */
  using /*typename*/ X::F;
  void f()
  {
    int x = 0;
    // F could be a function or it could be a struct - the compiler will complain
#ifndef AVOID_INTENTIONAL_ERRORS
    x = F();
#endif
    std::cout << x << std::endl;
  }
};

// Should be equivalent to Y<Obj>
struct Y2 : Obj
{
  void f()
  {
    // Definitely constructs an object of type F() and casts to an integer using a user-defined cast.
    int x = F();
    std::cout << x << std::endl;
  }
};

int main(void)
{
  // Fine, as long as we have the 'using' clause above, without typename: y.f() calls Func::F();
  Y<Func> y;
  y.f();

  // Should fail to compile unless we have 'using typename' above.
  Y<Obj> yp;
  yp.f();

  // No problem: just present for demonstration purposes.
  Y2 y2;
  y2.f();
}
