#include <memory>

class Scalar{
public:
  Scalar(double v) : m_value(v){}
  double operator[](size_t)const{return m_value;}
private:
  double m_value;
};

template<int SIZE>
class SimpleVector{
public:
  SimpleVector()
  {
  }
  
  SimpleVector(const SimpleVector& a)
  {
    for(std::size_t i=0 ; i < SIZE ; i++)
    {
      m_data[i] = a[i];
    }
  }
  
  SimpleVector& operator=(const SimpleVector& a)
  {
    for(std::size_t i=0 ; i < SIZE ; i++)
    {
      m_data[i] = a[i];
    }
    return *this;
  }
  
  double operator[](std::size_t i)const
  {
    return m_data[i];
  }

  double& operator[](std::size_t i)
  {
    return m_data[i];
  }
  
private:
  double m_data[SIZE];
};


template<int SIZE, typename InternalData = SimpleVector<SIZE>>
class Vector{
public:
  Vector()
  {
  }
  
  Vector(const InternalData& d) : m_data(d)
  {
  }
  
  template<typename InternalData2>
  const Vector<SIZE, InternalData>& operator=(const Vector<SIZE, InternalData2>& v)
  {
    for(std::size_t i=0 ; i < SIZE ; i++)
    {
      m_data[i] = v[i];
    }
    return *this;
  }
  

  double operator[](std::size_t i)const
  {
    return m_data[i];
  }

  double& operator[](std::size_t i)
  {
    return m_data[i];
  }
  
private:
  InternalData m_data;
};

template<int SIZE, typename Op1, typename Op2>
class VectorAdd
{
public:
  VectorAdd(const Op1& a, const Op2& b) : op1(a), op2(b)
  {
  }
  
  double operator[](std::size_t i)const
  {
    return op1[i] + op2[i];
  }
  
private:
  Op1 op1;
  Op2 op2;
};

template<int SIZE, typename InternalData1, typename InternalData2>
Vector<SIZE,VectorAdd<SIZE, Vector<SIZE,InternalData1>,Vector<SIZE,InternalData2>>>
operator+(const Vector<SIZE, InternalData1>& op1,
          const Vector<SIZE, InternalData2>& op2){
  return Vector<SIZE,
    VectorAdd<SIZE, Vector<SIZE, InternalData1>, Vector<SIZE,InternalData2>>>
    (VectorAdd<SIZE, Vector<SIZE,InternalData1>, Vector<SIZE,InternalData2>>(op1, op2));
}

template<int SIZE, typename InternalData1>
Vector<SIZE,VectorAdd<SIZE, Vector<SIZE,InternalData1>,Scalar>>
operator+(const Vector<SIZE, InternalData1>& op1,
          const double& op2){
  return Vector<SIZE,
    VectorAdd<SIZE, Vector<SIZE, InternalData1>, Scalar>>
    (VectorAdd<SIZE, Vector<SIZE,InternalData1>, Scalar>(op1, op2));
}


int main(void)
{
  Vector<4> a;
  a[0] = 5;
  Vector<4> b = a;
  Vector<4> c;
  c = a + b + a + 3.0;
  return 0;
}
