#include <vector>
#include <map>
#include <list>
#include <iostream>
#include <cmath>
#include <initializer_list>

class Matrix
{
public:
  Matrix(std::initializer_list<std::pair<double, double> > args)
  {
    if(args.size() != 2)
    {
      exit(1);
    }
    size_t i=0;
    for(auto it = args.begin() ; it != args.end() ; ++it, ++i)
    {
      data[i][0] = (*it).first;
      data[i][1] = (*it).second;
    }
  }
  
  double data[2][2];
};

int main(void)
{
  std::vector<int> a{1,2,3,5};
  std::map<int, double> b{ {1, M_PI}, {2, M_E}, {6, 9.80665} };
  
  std::cout << "a[2] = " << a[2] << std::endl;
  std::cout << "b[2] = " << b[2] << std::endl;

  Matrix m{{0, 1}, {3, 4}};

  std::cout << "m[1,0] = " << m.data[1][0] << std::endl;

  return 0;
}
