#include <iostream>
#include <type_traits>

template<typename T>
void print(T t, typename std::enable_if<std::is_pointer<T>::value, char>::type = 0)
{
  std::cout << "Pointer to " << *t << std::endl;
}

template<typename T>
void print(T t, typename std::enable_if<!std::is_pointer<T>::value, char>::type = 0)
{
  std::cout << "Value = " << t << std::endl;
}


template<typename T>
typename std::enable_if<std::is_pointer<T>::value>::type print2(T t)
{
  std::cout << "Pointer to " << *t << std::endl;
}

template<typename T>
typename std::enable_if<!std::is_pointer<T>::value>::type print2(T t)
{
  std::cout << "Value = " << t << std::endl;
}


int main(void)
{
  int a = 9;
  print(a);
  print(&a);
  print2(a);
  print2(&a);
}

