#include <vector>
#include <iostream>

template<typename T, typename S>
auto operator*(const std::vector<T>& v, const S& s) -> std::vector<decltype(T{} * S{})>
{
  std::vector<decltype(T{} * S{})> result(v.size());
  for(std::size_t i=0 ; i < v.size() ; i++)
  {
    result[i] = v[i] * s;
  }
  return result;
}

int main(void)
{
  std::vector<int> a{1, 3, 4, 6};

  std::vector<int> b = a * 3;
  std::vector<double> c = a * 3.5;

  for(unsigned int i=0 ; i < 4 ; i++)
  {
    std::cout << b[i] << " " << c[i] << std::endl;
  }
  

  return 0;
}
