/* Copyright (C) 1992  N.M. Maclaren
   Copyright (C) 1992  The University of Cambridge

    This software may be reproduced and used freely, provided that all
    users of it agree that the copyright holders are not liable for any
    damage or injury caused by use of this software and that this condition
    is passed onto all subsequent recipients of the software, whether
    modified or not.

This has been crudely hacked from the original C to be usable for
inclusion in C++.  It is also in Fortran.
*/



#include <cmath>

class dprand {

    const double xmod = 1000009711.0, ymod = 33554432.0,
        offset = 1.0/ymod, xmod2 = 2.0*xmod, xmod4 = 4.0*xmod,
        tiny = 1.0e-17;

/* The following is the workspace for the random number generator. */

    bool initial;
    int index;
    double poly[101], other;

/* This initialises the generator. */

    void sdprand (int seed) {
        int ix, iy, iz, i;
        double x;

/* seed should be set to an integer between 0 and 9999 inclusive; a value of 0
will initialise the generator only if it has not already been done. */

        if (initial || seed != 0)
            initial = false;
        else
            return;

/* index must be initialised to an integer between 1 and 101 inclusive,
poly[0...100] to integers between 0 and 1000009710 inclusive (not all 0), and
other to a non-negative proper fraction with denominator 33554432.  It uses the
Wichmann-Hill generator to do this. */

        ix = (seed >= 0 ? seed : -seed)%10000+1;
        iy = 2*ix+1;
        iz = 3*ix+1;
        for (i = -11; i < 101; ++i) {
            if (i >= 0) poly[i] = floor(xmod*x);
            ix = (171*ix)%30269;
            iy = (172*iy)%30307;
            iz = (170*iz)%30323;
            x = ((double)ix)/30269.0+((double)iy)/30307.0+
                    ((double)iz)/30323.0;
            x = x-floor(x);
        }
        other = floor(ymod*x)/ymod;
        index = 0;
    }

public:

    dprand () : initial(true) {}

    double operator() () {
        int n;
        double x, y;

/* This returns a uniform (0,1) random number, with extremely good uniformity
properties.  It assumes that double precision provides at least 33 bits of
accuracy, and uses a power of two base. */

        if (initial) sdprand(0);

/* See [Knuth] for why this implements the algorithm described in the paper.
Note that this code is tuned for machines with fast double precision, but slow
multiply and divide; many, many other options are possible. */

        if ((n = index-64) < 0) n += 101;
        x = poly[index]+poly[index];
        x = xmod4-poly[n]-poly[n]-x-x-poly[index];
        if (x <= 0.0) {
            if (x < -xmod) x += xmod2;
            if (x < 0.0) x += xmod;
        } else {
            if (x >= xmod2) {
                x = x-xmod2;
                if (x >= xmod) x -= xmod;
            }
            if (x >= xmod) x -= xmod;
        }
        poly[index] = x;
        if (++index >= 101) index = 0;

/* Add in the second generator modulo 1, and force to be non-zero.  The
restricted ranges largely cancel themselves out. */

        do {
            y = 37.0*other+offset;
            other = y-floor(y);
        } while (other == 0.0);
        if ((x = x/xmod+other) >= 1.0) x -= 1.0;
        return x+tiny;
    }
};

