/* Return high-precision timestamp. */

extern "C" {
    #include <stddef.h>
    #include <sys/time.h>

    double gettime_ (void) {
        struct timeval timer;
        if (gettimeofday(&timer,NULL)) return -1.0;
        return timer.tv_sec + 1.0e-6*timer.tv_usec;
    }
}
