#include <iostream>
#include <assert.h>

// Initial zero avoids confusion of referring to January as month zero.
const unsigned int daysInMonth[13] = {0,31,28,31,30,31,30,31,31,30,31,30,31};

class Date
{
public:
  Date(unsigned int, unsigned int, int);
  unsigned int day()const;
  unsigned int month()const;
  int year()const;
  
  void setDay(unsigned int);
  void setMonth(unsigned int);
  void setYear(int);

  void set(unsigned int, unsigned int, int);

  void advance();
  void back();

private:
  unsigned int myDay;
  unsigned int myMonth;
  int myYear;
};


Date::Date(unsigned int d, unsigned int m, int y)
{
  myDay = d;
  myMonth = m;
  myYear = y;

  assert( myMonth <= 12 );
  assert( d <= daysInMonth[myMonth] );
}

unsigned int Date::day()const
{
  return myDay;
}

unsigned int Date::month()const
{
  return myMonth;
}

int Date::year()const
{
  return myYear;
}

void Date::setDay(unsigned int d)
{
  assert( d <= daysInMonth[myMonth] );
  myDay = d;
}

void Date::setMonth(unsigned int m)
{
  assert( m <= 12 );
  assert( myDay <= daysInMonth[m] );
  myMonth = m;
}

void Date::setYear(int y)
{
  myYear = y;
}

void Date::set(unsigned int d, unsigned int m, int y)
{
  assert( m <= 12 );
  assert( d <= daysInMonth[m] );
  myDay = d;
  myMonth = m;
  myYear = y;
}


void Date::advance()
{
  myDay++;
  if( myDay > daysInMonth[myMonth] )
  {
    myMonth++;
    myDay = 1;
  }
  
  if( myMonth == 13 )
  {
    myYear++;
    myMonth = 1;
    myDay = 1;
  }
}

void Date::back()
{
  myDay--;
  if( myDay == 0 )
  {
    myMonth--;
    myDay = daysInMonth[myMonth];
  }
  
  if( myMonth == 0 )
  {
    myYear--;
    myMonth = 12;
    myDay = 31;
  }

  if( myYear == 0 )
  {
    myYear = -1;
  }
}

int main(void)
{
  Date d(31, 12, 2001);

  Date startOfTerm(6, 10, 2016);
  startOfTerm.advance();

  assert( startOfTerm.day() == 7 );
  assert( startOfTerm.month() == 10 );
  assert( startOfTerm.year() == 2016 );

  Date halloween(31, 10, 2016);
  halloween.advance();

  assert( halloween.day() == 1 );
  assert( halloween.month() == 11 );
  assert( halloween.year() == 2016 );

  /* This should fail (exit) at run-time because
     there is no 31st November. */
  halloween.setDay(31);

  halloween.set(31, 10, 2016); // This should succeed

  /* This should fail (exit) at run-time because
     there is no 31st November. */
  halloween.setMonth(11);

  Date startOfYear(1, 1, 2017);
  startOfYear.back();
  assert( startOfYear.day() == 31 );
  assert( startOfYear.month() == 12 );
  assert( startOfYear.year() == 2016 );

  const Date endOfYear = startOfYear;
  assert(endOfYear.day() == 31);
  endOfYear.setMonth(10); // Should fail at *compile-time*
  endOfYear = halloween; // Should fail at *compile-time*

  return 0;
}
