#include <iostream>

int** allocateMatrix(int N)
{
  int* mainBlock = new int[N*N];
  int** ptrsToRows = new int*[N];
  for(int i=0 ; i < N ; i++)
  {
    ptrsToRows[i] = mainBlock + i*N;
  }
  return ptrsToRows;
}

void freeMatrix(int** matrix)
{
  delete[] matrix[0];
  delete[] matrix;
}

int trace(int** m, int N)
{
  int t = 0;
  for(int i=0 ; i < N ; i++)
  {
    t += m[i][i];
  }
  
  return t;
}


int main(void)
{
  int n;
  std::cout << "Enter matrix size: ";
  std::cin >> n;
  int** m = allocateMatrix(n);

  for(int i=0 ; i < n ; i++)
  {
    for(int j=0 ; j < n ; j++)
    {
      m[i][j] = i + 3*j - i*i;
    }
  }  

  std::cout << trace(m, n);
  freeMatrix(m);
}
