#include <type_traits>
#include <iostream>

template<typename T>
class Vector
{
public:
  template<typename S>
  Vector(const S& s, typename std::enable_if<std::is_arithmetic<S>::value, int>::type = 0)
  {
    for(unsigned int i=0 ; i < 10 ; i++)
    {
      m_data[i] = s;
    }
  }

  template<typename S>
  Vector(const S& s, typename std::enable_if<!std::is_arithmetic<S>::value, int>::type = 0)
  {
    for(unsigned int i=0 ; i < 10 ; i++)
    {
      m_data[i] = s[i];
    }
  }

  T operator[](size_t i)const
  {
    return m_data[i];
  }
  

private:
  
  T m_data[10];
};


int main(void)
{
  Vector<double> a(9.6);

  Vector<int> b(10);
  Vector<int> c(a);

  for(unsigned int i=0 ; i < 10 ; i++)
  {
    std::cout << "a[" << i << "] = " << a[i] << std::endl;
  }

  for(unsigned int i=0 ; i < 10 ; i++)
  {
    std::cout << "b[" << i << "] = " << b[i] << std::endl;
  }

  for(unsigned int i=0 ; i < 10 ; i++)
  {
    std::cout << "c[" << i << "] = " << c[i] << std::endl;
  }
  
}
