#include <map>
#include <iostream>

class Shape
{
public:
  virtual void print()const = 0;
};


std::map<std::string, const Shape* (*)()> factory;

class Sphere : public Shape
{
public:
  static const Shape* create()
  {
    return new Sphere;
  }
  
  virtual void print()const
  {
    std::cout << "I am a Sphere" << std::endl;
  }
private:
  static const bool IsInFactory;
};

const bool Sphere::IsInFactory = factory.insert(std::make_pair("Sphere", &Sphere::create)).second;

class Triangle : public Shape
{
public:
  static const Shape* create()
  {
    return new Triangle;
  }
  
  virtual void print()const
  {
    std::cout << "I am a Triangle" << std::endl;
  }
private:
  static const bool IsInFactory;
};

const bool Triangle::IsInFactory = factory.insert(std::make_pair("Triangle", &Triangle::create)).second;

const Shape* getShape(const std::string& name){
  if(factory.find(name) != factory.end()){
    return factory[name]();
  }
  return NULL;
}

int main(void)
{
  const Shape* a = getShape("Sphere");
  a->print();

  const Shape* b = getShape("Triangle");
  b->print();

  const Shape* c = getShape("Ellipse");
  if(c) c->print();
}
