#include <cmath>
#include <iostream>
#include <iomanip>

template<typename T1, typename T2>
typename std::common_type<T1, T2>::type max(const T1& t1, const T2& t2){
  return (t1 > t2) ? t1 : t2;
}

int main(void)
{
  std::cout << std::setprecision(20);
  std::cout << "std::max() = " << std::max<double>(1.2, 2) << std::endl;
  std::cout << "max() = " << max(1.2, 2) << std::endl;
  std::cout << "std::max() = " << std::max<double>(M_PI, 2.3f) << std::endl;
  std::cout << "max() = " << max(M_PI, 2.3f) << std::endl;
  std::cout << "std::max() = " << std::max<float>(M_PI, 2.3f) << std::endl;
  std::cout << "max() = " << max<float>(M_PI, 2.3f) << std::endl;

  return 0;
}
