#include <iostream>

struct Vector
{
  Vector(size_t s)
  {
    m_size = s;
    m_data = new double[s];
  }

  Vector(const Vector& a)
  {
    m_size = a.m_size;
    m_data = new double[m_size];
    for(unsigned int i=0 ; i < m_size ; i++)
    {
      m_data[i] = a.m_data[i];
    }
    std::cout << "Copying vector the slow way." << std::endl;
  }

#if __cplusplus >= 201103L
  Vector(Vector&& a)
  {
    m_size = a.m_size;
    m_data = a.m_data;
    a.m_data = NULL;
    a.m_size = 0;
  }
#endif

  Vector& operator=(const Vector& a)
  {
    m_size = a.m_size;
    m_data = new double[m_size];
    for(unsigned int i=0 ; i < m_size ; i++)
    {
      m_data[i] = a.m_data[i];
    }
    std::cout << "Assigning vector the slow way." << std::endl;
    return *this;
  }
  

  ~Vector()
  {
    delete m_data;
  }
  
  double& operator[](size_t i)
  {
    return m_data[i];
  }

  const double& operator[](size_t i)const
  {
    return m_data[i];
  }
  
  size_t size()const
  {
    return m_size;
  }
  
private:
  double* m_data;
  size_t m_size;
};

Vector operator+(const Vector& a, const Vector& b)
{
#ifdef FORCE_COPY
  /* Note that it is only the presence of this
     if-statement that makes gcc-4.8 call the copy-constructor.
     Without it, the compiler uses the Return Value Optimization
     (unless -fno-elide-constructors is used), even at -O0.
   */
  if(a.size() != b.size())
  {
    return Vector(0);
  }
#endif  

  Vector c(a.size());
  for(size_t i=0 ; i < a.size() ; i++)
  {
    c[i] = a[i] + b[i];
  }
  return c;
}


int main(void)
{
  const int n = 1000;
  Vector a(n), b(n);

  for(unsigned int i=0 ; i < n ; i++)
  {
    a[i] = i*3;
    b[i] = i-9;
  }
  
  Vector c = a + b;

  std::cout << "c[9] = " << c[9] << std::endl;
  return 0;
}
