#include <vector>
#include <utility>
#include <iostream>

struct Vector
{
  Vector(size_t s)
  {
    m_size = s;
    m_data = new double[s];
    std::cout << "Construct Vector size " << s << std::endl;
  }

  Vector(const Vector& a)
  {
    m_size = a.m_size;
    m_data = new double[m_size];
    for(unsigned int i=0 ; i < m_size ; i++)
    {
      m_data[i] = a.m_data[i];
    }
    std::cout << "Copying vector the slow way." << std::endl;
  }

#if __cplusplus >= 201103L
  Vector(Vector&& a)noexcept
  {
    m_size = a.m_size;
    m_data = a.m_data;
    a.m_data = NULL;
    a.m_size = 0;
    std::cout << "Construct by move." << std::endl;
  }
#endif

  Vector& operator=(const Vector& a)
  {
    m_size = a.m_size;
    m_data = new double[m_size];
    for(unsigned int i=0 ; i < m_size ; i++)
    {
      m_data[i] = a.m_data[i];
    }
    std::cout << "Assigning vector the slow way." << std::endl;
    return *this;
  }

#if __cplusplus >= 201103L
  Vector& operator=(Vector&& a)
  {
    m_size = a.m_size;
    m_data = a.m_data;
    a.m_data = NULL;
    a.m_size = 0;
    std::cout << "Assignment by move." << std::endl;
    return *this;
  }
#endif  

  ~Vector()
  {
    delete m_data;
  }
  
  double& operator[](size_t i)
  {
    return m_data[i];
  }

  const double& operator[](size_t i)const
  {
    return m_data[i];
  }
  
  size_t size()const
  {
    return m_size;
  }
  
private:
  double* m_data;
  size_t m_size;
};

int main(void)
{
  std::vector<Vector> vecs;
  
  Vector a(10);
  
  std::cout << "Normal push-back" << std::endl;
  vecs.push_back(a);
  
  std::cout << "In-place push-back" << std::endl;
  vecs.push_back(Vector(10));
  
#if __cplusplus >= 201103L
  std::cout << "Move push-back" << std::endl;
  vecs.push_back(std::move(a));
  std::cout << "Vector a now has size " << a.size() << std::endl;

  std::cout << "Emplace insertion" << std::endl;
  vecs.emplace_back(10);
#endif

  return 0;
}
