#include <iostream>

class Base
{
public:
  Base(size_t s)
  {
    std::cout << "Allocating space for " << (1l << s) << " ints" << std::endl;
    m_baseData = new int[1l << s];
  }
  
  ~Base()
  {
    std::cout << "Deleting m_baseData" << std::endl;
    delete[] m_baseData;
  }
  
private:
  int* m_baseData;
};

class Derived : public Base
{
public:
  // Base class does not need much memory.
  Derived(size_t s) : Base(s-10)
  {
    // We now ask for a moderately large amount of memory.
    std::cout << "Allocating space for " << (1l << s) << " ints" << std::endl;
    try
    {
      m_derivedData1 = new int[1l << s];
    }
    catch(...)
    {
      m_derivedData1 = nullptr;
      std::cout << "Failed to allocate data" << std::endl;
      throw;
    }
    
    // Followed by a vast amount of memory.
    std::cout << "Allocating space for " << (1l << (s+10)) << " ints" << std::endl;
    try
    {
      m_derivedData2 = new int[1l << (s+10)];
    }
    catch(...)
    {
      delete[] m_derivedData1;
      m_derivedData2 = nullptr;
      std::cout << "Failed to allocate data" << std::endl;
      throw;
    }
  };

  ~Derived()
  {
    std::cout << "Deleting m_derivedData" << std::endl;
    delete[] m_derivedData1;
    delete[] m_derivedData2;
  }
  
private:
  int* m_derivedData1;
  int* m_derivedData2;

};

int main(void)
{
  try
  {
    Derived d(25);
    std::cout << "Successfully allocated space for d" << std::endl;
  }
  catch(...)
  {
    std::cout << "Failed to allocate d, but everything is now freed." << std::endl;
  }
  
  
}
