#include <iostream>
#include <memory>

struct A{
  std::shared_ptr<int> data;
  A(){
    data = std::shared_ptr<int>(new int[10], std::default_delete<int[]>());
  }
  A(const A& a)
  {
    data = a.data;
  }
  
  int& operator[](int i){
    return data.get()[i];
  }

  ~A()
  {
    // Only needed due to the explicit destructor calls below.
    data.reset();
    data = nullptr;
  }
  
};


A f(A a)
{
  A c = a;
  return c;
}

int main(void)
{
  A a;

  for(unsigned int i=0 ; i < 10 ; i++)
  {
    a[i] = i+3;
  }
  
  // Odd function call which copies 'a' to a local variable
  // and frees it in the function before passing a copy back.
  A b = f(a);

  // Demonstrate that b holds the same data as a.
  for(unsigned int i=0 ; i < 10 ; i++)
  {
    std::cout << "b[" << i << "] = " << b[i] << std::endl;
  }
  
  // Demonstrate that a and b point to the same memory.
  a[0] = 19;
  std::cout << "a[0] = " << a[0] << std::endl;
  std::cout << "b[0] = " << b[0] << std::endl;

  // Explicitly cause a to free its memory
  // (except it doesn't because b still holds a reference to it).
  a.~A();

  // This is not OK because a's pointer is null.
  // std::cout << "a[0] = " << a[0] << std::endl;

  // This is OK.
  std::cout << "b[0] = " << b[0] << std::endl;

  // Now cause b to free the memory.
  // It's the last holder of the reference, so the memory is freed.
  b.~A();

  // Calling this will result in a seg-fault (or at least undefined behaviour).
  //std::cout << "b[0] = " << b[0] << std::endl;

  return 0;
}
