#include <unordered_map>

struct Coord
{
  Coord(int i, int j) : x(i), y(j){ }
  int x;
  int y;
  bool operator==(const Coord& b)const
  {
    return (x == b.x) && (y == b.y);
  }
  
};

struct hashCoord
{
  size_t operator()(const Coord& a)const
  {
    return std::hash<int>()(a.x) ^ std::hash<int>()(a.y);
  }
};

int main(void)
{
  std::unordered_map<Coord, double, hashCoord> cellValues;
  Coord a(1,3);
  cellValues[a] = 3.0;
}
