#include <tuple>
#include <string>
#include <iostream>

void print()
{
}

template<typename T, typename... Args>
void print(const T& t, Args... a)
{
  std::cout << t << std::endl;
  print(a...);
}

double f(double x, double y, double z)
{
  return x*y*z;
}

template<typename F, typename... Args>
double fIncreased(F f, Args... x)
{
  return f((x+1)...);
}

int main(void)
{
  print("Hello", 10.9, 11u);
  std::cout << "f(3,4,5) = " << f(3,4,5) << std::endl;
  std::cout << "f(4,5,6) = " << fIncreased(f, 3,4,5) << std::endl;

}
