#include <iostream>
#include <string>


template<int N, typename... Elts> struct EltType;

template<int N, typename T, typename... Elts>
struct EltType<N, T, Elts...>
{
  typedef typename EltType<N-1, Elts...>::type type;
};

//! Recursion-ending specialisation
template<typename T, typename... Elts>
struct EltType<0, T, Elts...>
{
  typedef T type;
};

template<typename... Params> struct Tuple;

template<typename T, typename... OtherParams>
struct Tuple<T, OtherParams...> : Tuple<OtherParams...>{
  Tuple(T p, OtherParams... o) : Tuple<OtherParams...>(o...), param(p){
  }
  
  template<int N>
  typename std::enable_if<(N > 0), typename EltType<(N>0) ? N-1 : 0, OtherParams...>::type>::type get()const{
    return Tuple<OtherParams...>::template get<N-1>();
  }

  template<int N>
  typename std::enable_if<N == 0, T>::type
  get()const{
    return param;
  }
  T param;
};

template<>
struct Tuple<>
{
  Tuple()
  {
  }
};

int main(void)
{
  Tuple<int, double, std::string> t(3, 3.142, "Dave");
  std::cout << t.get<0>() << std::endl;
  std::cout << t.get<1>() << std::endl;
  std::cout << t.get<2>() << std::endl;
  return 0;
}
